//
//  MotionMonitorViewController.m
//  MotionMonitor
//
//  Created by Dave Mark on 12/15/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "MotionMonitorViewController.h"

@implementation MotionMonitorViewController
@synthesize motionManager;
@synthesize accelerometerLabel;
@synthesize gyroscopeLabel;


// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    self.motionManager = [[[CMMotionManager alloc] init] autorelease];
    NSOperationQueue *queue = [[[NSOperationQueue alloc] init] autorelease];
    if (motionManager.accelerometerAvailable) {
        motionManager.accelerometerUpdateInterval = 1.0/10.0;
        [motionManager startAccelerometerUpdatesToQueue:queue withHandler:
		 ^(CMAccelerometerData *accelerometerData, NSError *error){
			 NSString *labelText;
			 if (error) {
				 [motionManager stopAccelerometerUpdates];
				 labelText = [NSString stringWithFormat:
							  @"Przyspieszeniomierz napotkał błąd: %@", error];
			 } else {
				 labelText = [NSString stringWithFormat:
							  @"Przyspieszeniomierz\n-----------\nx: %+.2f\ny: %+.2f\nz: %+.2f", 
							  accelerometerData.acceleration.x, 
							  accelerometerData.acceleration.y, 
							  accelerometerData.acceleration.z];
			 }
			 [accelerometerLabel performSelectorOnMainThread:@selector(setText:) 
												  withObject:labelText 
											   waitUntilDone:YES];
		 }];
    } else {
        accelerometerLabel.text = @"To urządzenie nie posiada przyspieszeniomierza.";
    }
    if (motionManager.gyroAvailable) {
        motionManager.gyroUpdateInterval = 1.0/10.0;
        [motionManager startGyroUpdatesToQueue:queue withHandler:
		 ^(CMGyroData *gyroData, NSError *error) {
			 NSString *labelText;
			 if (error) {
				 [motionManager stopGyroUpdates];
				 labelText = [NSString stringWithFormat:
							  @"Żyroskop napotkał błąd: %@", error];
			 } else {
				 labelText = [NSString stringWithFormat:
							  @"Żyroskop\n--------\nx: %+.2f\ny: %+.2f\nz: %+.2f", 
							  gyroData.rotationRate.x, 
							  gyroData.rotationRate.y, 
							  gyroData.rotationRate.z];
			 }
			 [gyroscopeLabel performSelectorOnMainThread:@selector(setText:) 
											  withObject:labelText 
										   waitUntilDone:YES];
		 }];
    } else {
        gyroscopeLabel.text = @"To urządzenie nie posiada żyroskopu";
    }
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.motionManager = nil;
    self.accelerometerLabel = nil;
    self.gyroscopeLabel = nil;
    [super viewDidUnload];
}

- (void)dealloc {
    [motionManager release];
    [accelerometerLabel release];
    [gyroscopeLabel release];
    [super dealloc];
}

@end
